@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
@endpush
@section('content')
<section class="popular">
    <div class="container">
        <div class="row mb-3 justofy-content-center">
            <div class="col-lg-8">
                <div class="blog-page-left-content">
                    <div class="blog-page-left-image">
                        <a class="blogDetailsImage" href=""><img src="{{loadFile($destination->thumbnail)}}"
                                alt="Exploring the Hidden Gems of Argentina"></a>
                    </div>
                    <div class="blog-page-lef-info">
                        <br>
                    </div>
                    <h5>
                        <a href="">{{$destination->name}}</a>
                    </h5>
                    <p>
                        {!! $destination->description !!}
                    </p>

                    @if ($destination->places->count() > 0)
                    <h5>
                        @lang('app.places-to-visit')
                    </h5>
                    <div class="destination-details-price">
                        <div class="price-content">
                            <h6>@lang('app.price-includes')</h6>
                            <ul>
                                @forelse ($destination->places as $place)
                                <li><i class="fa-light fa-check"></i>{{$place->name}}</li>
                                @empty
                                <li>@lang('app.no-place-found')</li>
                                @endforelse
                            </ul>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mb-3">
                <h5>
                    @lang('app.package-list')
                </h5>
            </div>

            @forelse ($destination->packages as $package)
                <x-frontend.home.package :package="$package"/>
            @empty
                <div class="col-lg-12">
                    <div class="alert alert-danger text-center" role="alert">
                        @lang('app.no-package-found')
                    </div>
                </div>
            @endforelse
        </div>
    </div>
</section>
@endsection
